// CPPToolPlugIn.cpp
//
// This file implements an IPlugIn-derived class. The
// implementation creates a simple tool window inside
// the user interface of the TLA.
/////////////////////////////////////////////////////////////

#include "stdafx.h"

#using <system.windows.forms.dll>
#using <system.drawing.dll>
#using <system.dll>
#using "TlaNetInterfaces.dll"

#include "CPPToolPlugIn.h"

using namespace CPPSamplePlugIn;
using namespace System;
using namespace System::Windows::Forms;
using namespace Tektronix::LogicAnalyzer::TpiNet;
using namespace Tektronix::LogicAnalyzer::PlugIn;

// CPPToolPlugIn()
//
// The required default constructor of the IPlugIn-derived class
CPPToolPlugIn::CPPToolPlugIn() : m_isValid(true), m_isGarbage(false)
{
}


// Initialize()
//
// This method uses the supplied ITlaPlugInSupport object to embed its
// .NET form into main window of the TLA application.
bool CPPToolPlugIn::Initialize(ITlaPlugInSupport* support, bool userInit)
{
    m_form = new ToolForm(support);
    support->TopLevelFormToChild(m_form);
		    
	// This lets the plug-in know when the user closes the plug-in UI.
	m_form->add_Closed(new EventHandler
		(this, &CPPToolPlugIn::OnFormClosed));
	
	return true;
}


// Dispose()
//
// This method invalidates the plug-in and disposes of its window.
void CPPToolPlugIn::Dispose()
{
    if (m_isGarbage) {
        return;
    }
    
    if (m_form) {
		m_form->remove_Closed
			(new EventHandler(this, &CPPToolPlugIn::OnFormClosed));
        m_form->Dispose(true);
    }
    
    m_isValid = false;
    m_isGarbage = true;

    // A disposed plug-in must be invalid. When a plug-in becomes
    // invalid, it must raise its ValidityChanged event.
    raise_ValidityChanged(this , EventArgs::Empty);
}


// OnFormClosed()
//
// The plug-in subscribes to ToolForm.Closed. This event handler is 
// called when the event occurs. The plug-in responds by disposing 
//itself, which deletes the plug-in instance from the system.
void CPPToolPlugIn::OnFormClosed (System::Object* sender, System::EventArgs* e)
{
	Dispose();
}